<?php if (!defined('ABSPATH')) {
    die('Direct access forbidden.');
}

class Brizy_Editor_CompiledHtml
{

    /**
     * @var Brizy_Editor_Helper_Dom
     */
    private $dom;

    /**
     * Brizy_Editor_CompiledHtml constructor.
     *
     * @param $content
     */
    public function __construct($content)
    {
        $this->dom  = new Brizy_Editor_Helper_Dom($content);
    }

    /**
     * @return string
     * @deprecated Use getBody()
     */
    public function get_body()
    {
        return $this->getBody();
    }

    /**
     * @return string
     */
    public function getBody()
    {
        $body_tag = $this->dom->get_body();
        return $body_tag->get_content();
    }

    /**
     * @param bool $include_parent_tag
     *
     * @return string
     * @deprecated Use getHead)
     */
    public function get_head($include_parent_tag = false)
    {
        return $this->getHead($include_parent_tag);
    }

    /**
     * @param false $include_parent_tag
     * @return string
     */
    public function getHead($include_parent_tag = false)
    {
        $head_tag = $this->dom->get_head();
        return $head_tag->get_content();
    }

    /**
     * Extract the page content excluding headers and footers generated by Brizy
     */
    public function getPageContent()
    {
		$html = $this->getBody();

		if ( ! strpos( $html, 'brz-section__header' ) && ! strpos( $html, 'brz-footer' ) ) {
			return $html;
		}

		$parser = new Brizy_Parser_Parser( $html );
		$parser = $parser->getParser();

		$parser->remove( 'section', 'brz-section__header' );
		$parser->remove( 'footer', 'brz-footer' );

        return $parser->getHtml();
    }

}
